<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Post_Navigation extends \Elementor\Widget_Base
{
    /**
     * Get widget name.
     *
     * Retrieve oEmbed widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'adina-post-navigation';
    }
    /**
     * Get widget title.
     *
     * Retrieve oEmbed widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Post Navigation', 'adina');
    }
    /**
     * Get widget icon.
     *
     * Retrieve oEmbed widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-code';
    }
    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the oEmbed widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['adina'];
    }
    /**
     * Register oEmbed widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        /**
         * Content tab
         */
        $this->start_controls_section(
            'post_navigation',
            [
                'label' => __('Post Navigation', 'adina'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'prev_text',
            [
                'label' => __('Prev Text', 'adina'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Previous Project', 'adina'),
            ]
        );
        $this->add_control(
            'next_text',
            [
                'label' => __('Next Text', 'adina'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Next Project', 'adina'),
            ]
        );
        $this->add_control(
			'prev_icon',
			[
				'label' => __( 'Prev Icon', 'adina' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-arrow-left',
					'library' => 'solid',
				],
			]
        );
        $this->add_control(
			'next_icon',
			[
				'label' => __( 'Next Icon', 'adina' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-arrow-right',
					'library' => 'solid',
				],
			]
        );
        $this->add_control(
            'need_more_menu',
            [
                'label' => __( 'More Menu?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
			'more_menu_link',
			[
				'label' => __( 'More Menu URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->end_controls_section();
        /**
         * Style tab
         */
        $this->start_controls_section(
            'general',
            [
                'label' => __('Style', 'adina'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'label_typo',
                'label' => __('Prev Next Text Typography', 'adina'),
                'selector' => '{{WRAPPER}} .td-portfolio-more-content',
            ]
        );
        $this->start_controls_tabs(
            'nav_style_tabs'
        );
        $this->start_controls_tab(
            'nav_style_normal_tab',
            [
                'label' => __('Normal', 'adina'),
            ]
        );
        $this->add_control(
            'label_color',
            [
                'label' => __('label Color', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-content' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_menu_color',
            [
                'label' => __('More Menu Color', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-menu a svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-icon svg path' => 'stroke: {{VALUE}}',
                    '{{WRAPPER}} .td-portfolio-more-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'svg_fill_color',
            [
                'label' => __('Icon Fill Color', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nav_background',
            [
                'label' => __('Background Color', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'label' => __('Icon Border', 'adina'),
                'selector' => '{{WRAPPER}} .td-portfolio-more-icon',
            ]
        );
        $this->add_responsive_control(
            'nav_radius',
            [
                'label' => __('Border Radius', 'adina'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'body:not(.rtl) {{WRAPPER}} .td-portfolio-more-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .td-portfolio-more-icon' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'icon_gap',
			[
				'label' => __( 'Icon gap', 'adina' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .td-portfolio-more-icon i, body:not(.rtl) {{WRAPPER}} .td-portfolio-more-icon svg ' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .td-portfolio-more-icon i, body.rtl{{WRAPPER}} .td-portfolio-more-icon svg ' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_tab();
        $this->start_controls_tab(
            'nav_style_hover_tab',
            [
                'label' => __('Hover', 'adina'),
            ]
        );
        $this->add_control(
            'label_color_hover',
            [
                'label' => __('label Color', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-content:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label' => __('Icon', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-icon:hover svg path' => 'stroke: {{VALUE}}',
                    '{{WRAPPER}} .td-portfolio-more-icon:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'svg_fill_color_hover',
            [
                'label' => __('Icon Fill Color', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-icon:hover svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nav_background_hover',
            [
                'label' => __('Background Color', 'adina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-more-icon:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'nav_style_divider',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
			'icon_size',
			[
				'label' => __( 'Icon Size', 'adina' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-portfolio-more-icon svg' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-portfolio-more-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
        );
        $this->add_control(
			'icon_box_size',
			[
				'label' => __( 'Icon Box Size', 'adina' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-portfolio-more-icon' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
        );
        $this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-navigation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .td-portfolio-navigation',
			]
		);
        $this->end_controls_section();

    }
    /**
     * Render oEmbed widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $popular_post_key = array();
        $popular_meta_value_num = array();
        $settings = $this->get_settings_for_display();

        ob_start();
        \Elementor\Icons_Manager::render_icon( $settings['prev_icon'], [ 'aria-hidden' => 'true' ] );
        $prev_icon = ob_get_clean();

        ob_start();
        \Elementor\Icons_Manager::render_icon( $settings['next_icon'], [ 'aria-hidden' => 'true' ] );
        $next_icon = ob_get_clean();

        // Get previous and next posts
        $previous_post = get_previous_post();
        $next_post = get_next_post();

        ?>
                

                <div class="td-portfolio-navigation pb-110">
                    <div class="row align-items-center">
                        <?php if ($previous_post): ?>
                            <div class="col-sm-5 mb-30">
                                <div class="td-portfolio-more-left">
                                    <a href="<?php echo get_permalink(get_previous_post()->ID); ?>">
                                        <div class="td-portfolio-more-icon">
                                            <?php echo $prev_icon; ?>
                                        </div>
                                        <span class="td-portfolio-more-content ml-20">
                                            <?php echo esc_html($settings['prev_text']); ?>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if( $settings['need_more_menu'] == 'yes' ): ?>
                            <div class="col-sm-2 mb-30">
                                <div class="td-portfolio-more-menu text-center">
                                    <a href="<?php echo esc_url($settings['more_menu_link']['url']); ?>">
                                        <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_360_766)">
                                                <path d="M3.59989 0.268433C1.66541 0.268433 0.0917969 1.84215 0.0917969 3.77653C0.0917969 5.7109 1.66476 7.28451 3.59989 7.28451C5.53503 7.28451 7.10799 5.7109 7.10799 3.77653C7.10799 1.84215 5.53427 0.268433 3.59989 0.268433Z" fill="#20282D" />
                                                <path d="M14.9534 0.268433C13.019 0.268433 11.4453 1.84215 11.4453 3.77653C11.4453 5.7109 13.019 7.28451 14.9534 7.28451C16.8879 7.28451 18.4618 5.7109 18.4618 3.77653C18.4618 1.84215 16.8885 0.268433 14.9534 0.268433Z" fill="#20282D" />
                                                <path d="M26.4925 7.28462C28.4265 7.28462 30.0006 5.71101 30.0006 3.77664C30.0006 1.84226 28.4278 0.268433 26.4925 0.268433C24.5571 0.268433 22.9844 1.84215 22.9844 3.77653C22.9844 5.7109 24.5583 7.28462 26.4925 7.28462Z" fill="#20282D" />
                                                <path d="M3.50875 18.5257C5.44312 18.5257 7.01717 16.9524 7.01717 15.0177C7.01717 13.0829 5.44312 11.5093 3.50875 11.5093C1.57437 11.5093 0 13.083 0 15.0177C0 16.9524 1.57437 18.5257 3.50875 18.5257Z" fill="#20282D" />
                                                <path d="M14.8636 18.5257C16.7976 18.5257 18.3717 16.9524 18.3717 15.0177C18.3717 13.0829 16.7989 11.5093 14.8636 11.5093C12.9285 11.5093 11.3555 13.0829 11.3555 15.0177C11.3555 16.9524 12.9292 18.5257 14.8636 18.5257Z" fill="#20282D" />
                                                <path d="M26.402 18.5257C28.3368 18.5257 29.9101 16.9524 29.9101 15.0177C29.9101 13.0829 28.3368 11.5093 26.402 11.5093C24.4672 11.5093 22.8926 13.0829 22.8926 15.0177C22.8926 16.9524 24.4666 18.5257 26.402 18.5257Z" fill="#20282D" />
                                                <path d="M3.58882 22.7155C1.65445 22.7155 0.0800781 24.2887 0.0800781 26.2235C0.0800781 28.1576 1.65445 29.7315 3.58882 29.7315C5.5232 29.7315 7.09681 28.1584 7.09681 26.2235C7.09681 24.2887 5.5232 22.7155 3.58882 22.7155Z" fill="#20282D" />
                                                <path d="M14.9443 22.7155C13.0098 22.7155 11.4355 24.2887 11.4355 26.2235C11.4355 28.1576 13.0093 29.7315 14.9443 29.7315C16.8783 29.7315 18.4523 28.1584 18.4523 26.2235C18.4523 24.2887 16.8783 22.7155 14.9443 22.7155Z" fill="#20282D" />
                                                <path d="M26.4808 22.7155C24.5467 22.7155 22.9727 24.2887 22.9727 26.2235C22.9727 28.1576 24.5467 29.7315 26.4808 29.7315C28.4156 29.7315 29.9888 28.1584 29.9888 26.2235C29.9888 24.2887 28.4148 22.7155 26.4808 22.7155Z" fill="#20282D" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_360_766">
                                                <rect width="30" height="30" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($next_post): ?>
                            <div class="col-sm-5 mb-30">
                                <div class="td-portfolio-more-left text-right">
                                    <a href="<?php echo get_permalink(get_next_post()->ID); ?>">
                                        <span class="td-portfolio-more-content mr-20">
                                            <?php echo esc_html($settings['next_text']); ?>
                                        </span>
                                        <div class="td-portfolio-more-icon">
                                            <?php echo $next_icon; ?>
                                        </div>  
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
        <?php
    }


}


$widgets_manager->register( new \Post_Navigation() );